---
title: Analyze AI traffic · Cloudflare AI Crawl Control docs
description: AI Crawl Control metrics provide you with insight on how AI
  crawlers are interacting with your website (Cloudflare zone).
lastUpdated: 2025-10-24T00:15:37.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/ai-crawl-control/features/analyze-ai-traffic/
  md: https://developers.cloudflare.com/ai-crawl-control/features/analyze-ai-traffic/index.md
---

AI Crawl Control metrics provide you with insight on how AI crawlers are interacting with your website ([Cloudflare zone](https://developers.cloudflare.com/fundamentals/concepts/accounts-and-zones/#zones)).

To view AI Crawl Control metrics:

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.

2. Go to **AI Crawl Control**.

   [Go to **AI Crawl Control**](https://dash.cloudflare.com/?to=/:account/:zone/ai)

You can find meaningful information across both **Crawlers** and **Metrics** tabs.

## View AI crawler activity

The **Crawlers** tab provides you with the following information:

| Metric | Description |
| - | - |
| **Total requests** | Total number of requests to crawl your website from common AI crawlers. |
| **Requests by crawler** | Number of requests made by each AI crawler. |

## View AI Crawl Control metrics

The **Metrics** tab provides you with the following metrics to help you understand how AI crawlers are interacting with your website.

### Analyze referrer data

Note

This feature is available for customers on a paid plan.

Identify traffic sources with referrer analytics to understand discovery patterns and content popularity from AI operators.

* View top referrers driving traffic to your site.
* Understand discovery patterns and content popularity from AI operators.

### Track crawler requests over time

Visualize crawler activity patterns over time using the **Requests over time** chart. You can group data by different dimensions to get more specific insights:

| Dimension | Description |
| - | - |
| **Crawler** | Track activity from individual AI crawlers (like GPTBot, ClaudeBot, and Bytespider). |
| **Category** | Analyze crawlers by their purpose or type. |
| **Operator** | Discover which companies (such as OpenAI, Anthropic, and ByteDance) are crawling your site. |
| **Host** | Break down activity across multiple subdomains. |
| **Status Code** | Monitor HTTP response codes (200s, 300s, 400s, 500s) to crawlers. |

### Understand what content is crawled

The **Most popular paths** table shows you which pages on your site are most frequently requested by AI crawlers. This can help you understand what content is most popular with different AI models.

| Column | Description |
| - | - |
| **Path** | The path of the page on your website that was requested. |
| **Hostname** | The hostname of the requested page. |
| **Crawler** | The name of the AI crawler that made the request. |
| **Operator** | The company that operates the AI crawler. |
| **Allowed requests** | The number of times the path was successfully requested by the crawler. |

You can also filter the results by path or content type to narrow down your analysis.

## Filter and export data

You can use the date filter to choose the period of time you wish to analyze. To export your data, select **Download CSV**. The downloaded file will include all applied filters and groupings.

* Free plans

  Filter options:

  * Past 24 hours

* Paid plans

  Filter options:

  * Past 24 hours
  * Past 7 days
  * Past 14 days
  * Past month

The values of the AI Crawl Control metrics will update according to your filter.
