---
title: Challenges · Cloudflare challenges docs
description: When a Challenge is issued, Cloudflare asks the browser to perform
  a series of checks that help confirm the visitor's legitimacy. This process
  involves evaluating client-side signals or asking a visitor to take minimal
  action such as checking a box or selecting a button.
lastUpdated: 2025-06-24T17:41:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-challenges/
  md: https://developers.cloudflare.com/cloudflare-challenges/index.md
---

Challenges are security mechanisms used by Cloudflare to verify whether a visitor to your site is a real human and not a bot or automated script.

When a Challenge is issued, Cloudflare asks the browser to perform a series of checks that help confirm the visitor's legitimacy. This process involves evaluating client-side signals or asking a visitor to take minimal action such as checking a box or selecting a button.

Challenges are designed to protect your application without introducing unnecessary friction. Most visitors will pass Challenges automatically without interaction.

Cloudflare does not use CAPTCHA puzzles or visual tests like selecting objects or typing distorted characters. All challenge types are lightweight, privacy-preserving, and optimized for real-world traffic.

***

## Related products

**[Turnstile](https://developers.cloudflare.com/turnstile/)**

Use Cloudflare's smart CAPTCHA alternative to run less intrusive Challenges.

**[Bots](https://developers.cloudflare.com/bots/)**

Cloudflare bot solutions identify and mitigate automated traffic to protect your domain from bad bots.

**[WAF](https://developers.cloudflare.com/waf/)**

Get automatic protection from vulnerabilities and the flexibility to create custom rules.

**[DDoS Protection](https://developers.cloudflare.com/ddos-protection/)**

Detect and mitigate Distributed Denial of Service (DDoS) attacks using Cloudflare's Autonomous Edge.
