---
title: sFlow DDoS attack rule · Cloudflare Magic Network Monitoring docs
description: Magic Network Monitoring customers that send sFlow data to
  Cloudflare can receive alerts when a specific type of distributed
  denial-of-service (DDoS) attack is detected within their network traffic.
  Magic Network Monitoring uses the same DDoS attack detection rules that
  protect Cloudflare's global network to generate these alerts for customers.
lastUpdated: 2025-10-16T11:21:23.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-network-monitoring/rules/s-flow-ddos-attack/
  md: https://developers.cloudflare.com/magic-network-monitoring/rules/s-flow-ddos-attack/index.md
---

Magic Network Monitoring customers that send sFlow data to Cloudflare can receive alerts when a specific type of distributed denial-of-service (DDoS) attack is detected within their network traffic. Magic Network Monitoring uses the same DDoS attack detection rules that protect Cloudflare's global network to generate these alerts for customers.

Only customers that send sFlow data to Cloudflare can configure a sFlow DDoS attack rule.

An sFlow DDoS attack rule can only be configured via Cloudflare's API. Today, customers are unable to configure a sFlow DDoS attack rule in the Cloudflare dashboard.

## Send sFlow data from your network to Cloudflare

Customers can export sFlow data of their network traffic to Cloudflare via Magic Network Monitoring. There are [specific brands and models](https://developers.cloudflare.com/magic-network-monitoring/routers/supported-routers/) of routers that are capable of generating sFlow data. Make sure to check the router specifications to ensure that it is able to export sFlow data. Customers can follow this [sFlow configuration guide](https://developers.cloudflare.com/magic-network-monitoring/routers/sflow-config/) to configure sFlow exports to Magic Network Monitoring.

## Rule configuration fields

| Field | Description |
| - | - |
| **Rule name** | Must be unique and cannot contain spaces. Supports characters `A-Z`, `a-z`, `0-9`, underscore (`_`), dash (`-`), period (`.`), and tilde (`~`). Maximum of 256 characters. |
| **Rule type** | advanced\_ddos |
| **Prefix Match** | The field `prefix_match` determines how IP matches are handled.- **Recommended**
- * **Subnet**: Automatically advertise if the attacked IPs are within a subnet of a public IP prefix that can be advertised by Magic Transit.
  **Other prefix match options**
  * **Exact**: Automatically advertise if the attacked IPs are an exact match with a public IP prefix that can be advertised by Magic Transit.
  * **Supernet**: Automatically advertise if the attacked IPs are a supernet of a public IP prefix that can be advertised by Magic Transit. |
| **Auto-advertisement** | If you are a [Magic Transit On Demand](https://developers.cloudflare.com/magic-transit/on-demand) customer, you can enable this feature to automatically enable Magic Transit if the rule's dynamic threshold is triggered. To learn more refer to [Auto-Advertisement section](https://developers.cloudflare.com/magic-network-monitoring/rules/#rule-auto-advertisement). |
| **Rule IP prefix** | The IP prefix associated with the rule for monitoring traffic volume. Must be a CIDR range such as `160.168.0.1/24`. The maximum is 5,000 unique CIDR entries. To learn more and see an example, view the [Rule IP prefixes](https://developers.cloudflare.com/magic-network-monitoring/rules/#rule-ip-prefixes)] section. |

## API documentation

Go to the [Rules](https://developers.cloudflare.com/api/resources/magic_network_monitoring/subresources/rules/) section in the Magic Network Monitoring's API documentation to review an example API configuration call using CURL and the expected output for a successful response.

## Tune the sFlow DDoS alert thresholds

Customers can tune the thresholds of their sFlow DDoS alerts in the dashboard and via the Cloudflare API by following the [Network-layer DDoS Attack Protection managed ruleset](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/) guide.
